<?php

namespace App\Http\Controllers;

use App\Models\GambarPromo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class GambarPromoController extends Controller
{
    public function index()
    {
        $promos = GambarPromo::all();
        return view('admin.gambarpromo.index', compact('promos'));
    }

    public function create()
    {
        return view('admin.gambarpromo.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nama' => 'required|string|max:255',
            'caption' => 'nullable|string',
            'jenis_promo' => 'nullable|array',
            'jenis_promo.*' => 'nullable|string',
            'gambar' => 'nullable|image|max:2048',
        ]);
        if ($request->hasFile('gambar')) {
            $data['gambar'] = $request->file('gambar')->store('promo', 'public');
        }
        $data['jenis_promo'] = json_encode($request->jenis_promo);
        GambarPromo::create($data);
        return redirect()->route('admin.gambarpromo.index')->with('success', 'Promo berhasil ditambahkan.');
    }

    public function edit($id)
    {
        $promo = GambarPromo::findOrFail($id);
        return view('admin.gambarpromo.edit', compact('promo'));
    }

    public function update(Request $request, $id)
    {
        $promo = GambarPromo::findOrFail($id);
        $data = $request->validate([
            'nama' => 'required|string|max:255',
            'caption' => 'nullable|string',
            'jenis_promo' => 'nullable|array',
            'jenis_promo.*' => 'nullable|string',
            'gambar' => 'nullable|image|max:2048',
        ]);
        if ($request->hasFile('gambar')) {
            if ($promo->gambar) Storage::disk('public')->delete($promo->gambar);
            $data['gambar'] = $request->file('gambar')->store('promo', 'public');
        }
        $data['jenis_promo'] = json_encode($request->jenis_promo);
        $promo->update($data);
        return redirect()->route('admin.gambarpromo.index')->with('success', 'Promo berhasil diupdate.');
    }

    public function show($id)
    {
        $promo = GambarPromo::findOrFail($id);
        return view('admin.gambarpromo.show', compact('promo'));
    }

    public function destroy($id)
    {
        $promo = GambarPromo::findOrFail($id);
        if ($promo->gambar) Storage::disk('public')->delete($promo->gambar);
        $promo->delete();
        return redirect()->route('admin.gambarpromo.index')->with('success', 'Promo berhasil dihapus.');
    }
} 