<?php

namespace App\Http\Controllers;

use App\Models\KontakWa;
use Illuminate\Http\Request;

class KontakWaController extends Controller
{
    public function index()
    {
        $kontaks = KontakWa::all();
        return view('admin.kontakwa.index', compact('kontaks'));
    }

    public function create()
    {
        return view('admin.kontakwa.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nomor' => 'required|string|max:255',
        ]);
        KontakWa::create($data);
        return redirect()->route('admin.kontakwa.index')->with('success', 'Nomor WA berhasil ditambahkan.');
    }

    public function edit($id)
    {
        $kontak = KontakWa::findOrFail($id);
        return view('admin.kontakwa.edit', compact('kontak'));
    }

    public function update(Request $request, $id)
    {
        $kontak = KontakWa::findOrFail($id);
        $data = $request->validate([
            'nomor' => 'required|string|max:255',
        ]);
        $kontak->update($data);
        return redirect()->route('admin.kontakwa.index')->with('success', 'Nomor WA berhasil diupdate.');
    }

    public function show($id)
    {
        $kontak = KontakWa::findOrFail($id);
        return view('admin.kontakwa.show', compact('kontak'));
    }

    public function destroy($id)
    {
        $kontak = KontakWa::findOrFail($id);
        $kontak->delete();
        return redirect()->route('admin.kontakwa.index')->with('success', 'Nomor WA berhasil dihapus.');
    }
} 