<?php

namespace App\Http\Controllers;

use App\Models\TampakRumah;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class TampakRumahController extends Controller
{
    public function index()
    {
        $ruangans = TampakRumah::all();
        return view('admin.tampakrumah.index', compact('ruangans'));
    }

    public function create()
    {
        return view('admin.tampakrumah.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nama' => 'required|string|max:255',
            'gambar' => 'nullable|image|max:2048',
        ]);
        if ($request->hasFile('gambar')) {
            $data['gambar'] = $request->file('gambar')->store('tampak_rumah', 'public');
        }
        TampakRumah::create($data);
        return redirect()->route('admin.tampakrumah.index')->with('success', 'Ruangan berhasil ditambahkan.');
    }

    public function edit($id)
    {
        $ruangan = TampakRumah::findOrFail($id);
        return view('admin.tampakrumah.edit', compact('ruangan'));
    }

    public function update(Request $request, $id)
    {
        $ruangan = TampakRumah::findOrFail($id);
        $data = $request->validate([
            'nama' => 'required|string|max:255',
            'gambar' => 'nullable|image|max:2048',
        ]);
        if ($request->hasFile('gambar')) {
            if ($ruangan->gambar) Storage::disk('public')->delete($ruangan->gambar);
            $data['gambar'] = $request->file('gambar')->store('tampak_rumah', 'public');
        }
        $ruangan->update($data);
        return redirect()->route('admin.tampakrumah.index')->with('success', 'Ruangan berhasil diupdate.');
    }

    public function show($id)
    {
        $ruangan = TampakRumah::findOrFail($id);
        return view('admin.tampakrumah.show', compact('ruangan'));
    }

    public function destroy($id)
    {
        $ruangan = TampakRumah::findOrFail($id);
        if ($ruangan->gambar) Storage::disk('public')->delete($ruangan->gambar);
        $ruangan->delete();
        return redirect()->route('admin.tampakrumah.index')->with('success', 'Ruangan berhasil dihapus.');
    }
} 