<x-admin>
@section('title', 'Status Karir')
<div class="container">
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h3 class="font-weight-bold">Status Karir</h3>
                <a href="{{ route('admin.karir.create') }}" class="btn btn-outline-secondary">Tambah Lowongan</a>
            </div>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Jabatan</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($karirs as $karir)
                    <tr>
                        <td>{{ $karir->jabatan }}</td>
                        <td>
                            @if($karir->status == 'Open')
                                <span class="badge badge-success">Open</span>
                            @elseif($karir->status == 'Closed')
                                <span class="badge badge-danger">Closed</span>
                            @else
                                <span class="badge badge-warning">Pending</span>
                            @endif
                        </td>
                        <td><a href="{{ route('admin.karir.edit', $karir->id) }}" class="btn btn-primary btn-sm">Lihat/edit</a></td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="3" class="text-center text-muted">Belum ada lowongan yang terdaftar.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
</x-admin> 