<x-admin>
@section('title', 'Simulasi KPR')
<div class="container">
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h3 class="font-weight-bold">Simulasi KPR</h3>
                <a href="{{ route('admin.simulasikpr.create') }}" class="btn btn-outline-secondary">Tambah Bank</a>
            </div>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Bank</th>
                        <th>Jenis Program</th>
                        <th>Suku Bunga</th>
                        <th>Tempo Angsuran</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($simulasis as $simulasi)
                    <tr>
                        <td>{{ $simulasi->bank }}</td>
                        <td>
                            @if($simulasi->jenis_program)
                                @foreach((array) $simulasi->jenis_program as $prog)
                                    <div>{{ $prog }}</div>
                                @endforeach
                            @endif
                        </td>
                        <td>{{ $simulasi->suku_bunga }}</td>
                        <td>
                            @if($simulasi->tempo_angsuran)
                                @foreach((array) $simulasi->tempo_angsuran as $tempo)
                                    <div>{{ $tempo }}</div>
                                @endforeach
                            @endif
                        </td>
                        <td><a href="{{ route('admin.simulasikpr.edit', $simulasi->id) }}" class="btn btn-primary btn-sm">Lihat/edit</a></td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center text-muted">Belum ada simulasi KPR yang terdaftar.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
</x-admin> 